<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\InvestmentDataTable;
use App\Models\Investment;
use App\Models\Type;

class InvestmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index(InvestmentDataTable $dataTable) {
        return $dataTable->render('admin.investments.index', ['title' => 'Contrôle des investissements']);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
      public function create() {
        $types = Type::all();
        $select = [];
        foreach($types  as $type){
            $select[$type->id] = $type->name;
        }
        return view('admin.investments.create', ['title' => 'Ajoute Investissement'],compact('select'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
      public function store() {
        $data = $this->validate(request(),
            [   'type_id'     => 'required',
                'description' => 'required',
                'amount'      => 'required|numeric',
                'quantity'    => 'required|numeric',
            ], [], [
                'type_id'     => 'type_id',
                'description' => 'description',
                'amount'      => 'amount',
                'quantity'    => 'quantity',
            ]);
        Investment::create($data);
        session()->flash('success', 'Enregistrement ajoute');
        return redirect(aurl('investments'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
      public function edit($id) {
        $investment = Investment::find($id);
        $title = 'Investissement Edit';

        $types = Type::all();
        $select = [];
        foreach($types  as $type){
            $select[$type->id] = $type->name;
        }
        return view('admin.investments.edit', compact('investment', 'title' , 'select'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
      public function update(Request $r, $id) {

        $data = $this->validate(request(),
            [
                'type_id'     => 'required',
                'description' => 'required',
                'amount' => 'required|numeric',
                'quantity' => 'required|numeric',
              ], [], [
                'type_id'     => 'type_id',
                'description' => 'description',
                'amount'      => 'amount',
                'quantity'    => 'quantity',
                                 ]);
     
        Investment::where('id', $id)->update($data);
        session()->flash('success', trans('Enregistrement mise a jour'));
        return redirect(aurl('investments'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Investment::find($id)->delete();
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('investments'));
    }
}
