<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{


    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->string('ref')->nullable();
            $table->string('description')->nullable();
            $table->string('payment_supplier')->nullable();
            $table->string('payment_delivery')->nullable();
            $table->bigInteger('shipping_company_id')->unsigned();
            $table->string('category')->nullable();
            $table->bigInteger('provider_id')->unsigned();
            $table->decimal('buy_price', 9, 0)->default(0);
            $table->decimal('sell_price', 9, 0)->default(0);
            $table->integer('quantity')->default(1);
            $table->decimal('sup_fees', 9, 0)->default(0);
            $table->dateTime('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->dateTime('updated_at')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
