@extends('admin.index')
@section('content')

<div class="row">
  @foreach ($shipments as $shipment)
  @php
  $sumPaye = 0;  $sumNonPaye = 0;
  @endphp
  <div class="col-md-4">
   <!-- Widget: user widget style 1 -->
   <div class="box box-widget widget-user-2">
     <!-- Add the bg color to the header using any of the bg-* classes -->
     <div class="widget-user-header bg-green text-center">
     <h2>  <strong>  {{$shipment[0]->name}}</strong> </h2>
     </div>
     <div class="box-footer no-padding">

      @foreach ($shipment as $trans)
          @if($trans->payment_delivery == 'Paye')
            @php $sumPaye += ($trans->sell_price - ($trans->sell_price * $trans->tax / 100)) @endphp
          @endif
          @if($trans->payment_delivery == 'NonPaye')
            @php $sumNonPaye += ($trans->sell_price - ($trans->sell_price * $trans->tax / 100))  @endphp
          @endif
      @endforeach
  <ul class="nav nav-stacked">
   <li><a href="#">Non Paye  Transactions<span class="pull-right badge bg-red">  {{ number_format($sumNonPaye, 0, '.', ' ') }} DA</span></a></li>
   <li><a href="#">Paye  Transactions<span class="pull-right badge bg-green">  {{ number_format($sumPaye, 0, '.', ' ')  }}DA </span></a></li>
 </ul>
</div>
</div>
<!-- /.widget-user -->
</div>
 @endforeach
          <!-- /.widget-user -->
     
        <!-- /.col -->  
      </div>
      <!-- Small boxes (Stat box) -->
  
      <div class="row text-center" >
          <div class="col-lg-12 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-yellow">
            <div class="inner">
              <h1> Bilan Actuel :<strong> {{  number_format($bilanActuel, 0, '.', ' ') }} DA </strong> </h1>
            </div>

          </div>
        </div>
      </div>
             


  <div class="row text-center">
         <div class="col-lg-6 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-green">
            <div class="inner">
              <h3> {{ number_format($totalProfit, 0, '.', ' ') }} DA</h3>
              <p><h3>La Caisse</h3></p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-6 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-red">
            <div class="inner">
              <h3> {{ number_format($sumShippingUnPaidInt, 0, '.', ' ')}} DA</h3>
              <p><h3>Compagnie de livraison</h3></p>
            </div>
            <div class="icon">
              <i class="fa fa-truck"></i>
            </div>         
           </div>
        </div>
      </div>
     
          <!-- /.box -->   
      <div class="row">
      
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-maroon">
            <div class="inner">
              <h2> {{ number_format($sumShippingPaidInt + $sumShippingUnPaidInt, 0, '.', ' ') }} DA  </h2>
              <p><h2>Transactions</h2></p>
            </div>
            <div class="icon">
              <i class="ion ion-bag"></i>
            </div>
            <a href="{{ aurl('transactions') }}" class="small-box-footer">Plus d'informations<i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-aqua">
            <div class="inner">
              <h2> {{ number_format($sumCharge, 0, '.', ' ') }}  DA </h2>

              <p><h2>Charges</h2></p>
            </div>
            <div class="icon">
              <i class="fa  fa-tasks"></i>
            </div>
            <a href="{{ aurl('charges') }}" class="small-box-footer">Plus d'informations<i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-purple">
            <div class="inner">
              <h2>{{ number_format($sumStock, 0, '.', ' ') }} DA </h2>

              <p><h2>Stock</h2></p>
            </div>
            <div class="icon">
              <i class="fa  fa-cubes"></i>
            </div>
            <a href="{{ aurl('stock') }}" class="small-box-footer">Plus d'informations<i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
      

        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-navy">
            <div class="inner">
              <h2>{{ number_format($sumInvestment, 0, '.', ' ') }} DA </h2>

              <p><h2>Investissements</h2></p>
            </div>
            <div class="icon">
              <i class="fa  fa-refresh"></i>
            </div>
            <a href="{{ aurl('investments') }}" class="small-box-footer">Plus d'informations<i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
      </div>
      <!-- /.row -->
      <!-- Main row -->
    
      <!-- /.row (main row) -->

      <div class="row">
      @foreach ($providers as $provider)
      @php
      $payeSum = 0;  $nonPayeSum = 0;
      @endphp
        <div class="col-md-4 col-sm-6 col-xs-12">
          <div class="info-box bg-green">
            <span class="info-box-icon"><i class="fa fa-user"></i></span>
  
            <div class="info-box-content">
              <span class="info-box-text"> {{$provider[0]->name}}</span>
              @foreach ($provider as $trans)
              @if($trans->payment_supplier == 'Paye')
                @php $payeSum += ($trans->buy_price ) @endphp
              @endif
              @if($trans->payment_supplier == 'NonPaye')
                @php $nonPayeSum += ($trans->buy_price)  @endphp
              @endif
             @endforeach
              <span class="info-box-number">Endette : {{ number_format($nonPayeSum, 0, '.', ' ') }} DA</span>
              <div class="progress">
                <div class="progress-bar" style="width: 100%"></div>
              </div>
                  <span class="progress-description">
                  Paye :   {{ number_format($payeSum, 0, '.', ' ') }} DA    
                  </span>
            </div>
          </div>
        </div>
      @endforeach 
      </div>
     
   
      <div class="chart-title"><h2>Diagramme  pour chaque transactions par jours</h2></div>
      <div id="chart-container-days"></div>

      <div class="chart-title"><h2>Diagramme  pour chaque transactions par mois</h2></div>
      <div id="chart-container-month"></div>
@endsection



      @push('js')
      <script>
     var datas =  {{ json_encode($datas) }} 
      Highcharts.chart('chart-container-month', { 
        title: {
          text:'New Trans Growth 2021'
        },
        subtitle: {
          text:'New Trans Growth 2021'
        },
        xAxis: {
          categories:['janvier','février','mars','avril','mai','juin','juillet','août',
          'septembre','october','novembre','décembre']
        },
      yAxis: {
        title: { 
          text: "Number of new Trans"
        }
      },
      legend:{
        layout:'vertical',
        align:'right',
        verticalAlign:'midle'
      },
      plotOptions: {
        series: { 
          allowPointSelect:true
        }
      },
      series : [{
        name:'New Trans',
        data: datas
      }],
      responsive: {
        rules: [
          {
            condition: { 
              maxWidth:500
            },
            chartOptions:{
              legend:{
                layout:'horizontal',
                align:'center',
                verticalAlign:'bottom',
              }
            }
          }
        ]
      }
      })

var transDays =  {{ json_encode($transDays) }} 

Highcharts.chart('chart-container-days', { 
  title: {
    text:'New Trans Growth This Month'
  },
  subtitle: {
    text:'New Trans Growth This Month'
  },
  xAxis: {
    categories:['1','2','3','4','5','6','7','8',
    '9','10','11','12','13','14','15','16','17','18','19','20',
    '21','22','23','24','25','26','27','28','29','30','31']
  },
yAxis: {
  title: { 
    text: "Number of new Trans each day"
  }
},
legend:{
  layout:'vertical',
  align:'right',
  verticalAlign:'midle'
},
plotOptions: {
  series: { 
    allowPointSelect:true
  }
},
series : [{
  name:'New Trans',
  data: transDays
}],
responsive: {
  rules: [
    {
      condition: { 
        maxWidth:500
      },
      chartOptions:{
        legend:{
          layout:'horizontal',
          align:'center',
          verticalAlign:'bottom',
        }
      }
    }
  ]
}
})
</script>
@endpush