<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Type extends Model
{
    use HasFactory;
    protected $table = "types";
    protected $fillable = ["name"];
    protected $casts = [
    'created_at' => 'datetime:Y-m-d',
    'updated_at' => 'datetime:Y-m-d',
];

    public function charge()
    {
        return $this->hasMany(Charge::class);
    }

    public function investment()
    {
        return $this->hasMany(Investment::class);
    }
    
}
