<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Response;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/admin', function () {
//     return view('admin/home');
// });
Route::get('/', function () {
  return view('auth.login');
});


Route::group(['prefix' => 'admin'], function () {

  Route::group(['middleware' => 'auth'], function () {
    Route::resources([
      'admins' => AdminAuth::class,
      'stock' => StockController::class,
      'charges' => ChargesController::class,
      'transactions' => TransactionsController::class,
      'types' => TypesController::class,
      'investments' => InvestmentController::class,
      'providers' => ProviderController::class,
      'shippingcompanies' => ShippingCompanyController::class,
      'daterange' => DateRangeController::class

    ]);

    
  Route::get('download', [\App\Http\Controllers\ChargesController::class, 'downloadFile']);


    Route::get('/', [\App\Http\Controllers\AdminHomeController::class, 'index']);
    //Route::resource('/daterange', App\Http\Controllers\DateRangeController::class);
    //Route::get('/daterange', [App\Http\Controllers\DateRangeController::class]);

  });
});




Auth::routes();


Route::get('/register', function () {
  return redirect('/login');
});

Route::post('/register', function () {
  return redirect('/login');
});
//   Route::get('/', [\App\Http\Controllers\AdminHomeController::class,'index']);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
