<?php

namespace App\DataTables;

use App\Models\Transaction;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class TransactionDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables($query)
            ->addColumn('edit', 'admin.transactions.btn.edit')
            ->addColumn('delete', 'admin.transactions.btn.delete')
            ->rawColumns([
                'edit',
                'delete',
            ]);
    }


    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Transaction $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Transaction $model)
    {
        return $model->newQuery()->with('shippingcompany', 'provider');
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */


    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->parameters([
                'dom'        => 'Blfrtip',
                'lengthMenu' => [[30, 50, 100, 150], [30, 50, 100, 'All Recored']],
                'buttons'    => [
                    [
                        'text' => '<i class="fa fa-plus"></i> ' . 'Ajoute Transaction', 'className' => 'btn btn-primary', "action" => "function(){

                            window.location.href = 'transactions/create';
                        }"
                    ],

                    ['extend' => 'print', 'className' => 'btn btn-warning', 'text' => '<i class="fa fa-print"></i>'],
                    ['extend' => 'csv', 'className' => 'btn btn-info', 'text' => '<i class="fa fa-file"></i> ' . 'CSV'],
                    ['extend' => 'excel', 'className' => 'btn btn-success', 'text' => '<i class="fa fa-file"></i> ' . 'Excel'],
                    ['extend' => 'reload', 'className' => 'btn btn-default', 'text' => '<i class="fa fa-refresh"></i>'],

                ],
                'initComplete' => " function () {
                    this.api().columns([1,2,9]).every(function () {
                        var column = this;
                        var input = document.createElement(\"input\");
                        $(input).appendTo($(column.footer()).empty())
                        .on('keyup', function () {
                            column.search($(this).val(), false, false, true).draw();
                        });
                    });
                }",


            ]);
    }
    /**
     * Get columns.
     *
     * @return array
     */
 
    protected function getColumns()
    {

        return [
            [
                'name'       => 'edit',
                'data'       => 'edit',
                'title'      => 'edit',
                'exportable' => false,
                'printable'  => false,
                'orderable'  => false,
                'searchable' => false,
            ], 
            [
                'name'  => 'ref',
                'data'  => 'ref',
                'title' => 'ref',
            ], 
            [
                'name'  => 'description',
                'data'  => 'description',
                'title' => 'description',
            ],
             [
                'name'  => 'shippingcompany',
                'data'  => 'shippingcompany.name',
                'title' => 'livraison',
            ],
             [
                'name'  => 'payment_delivery',
                'data'  => 'payment_delivery',
                'title' => 'état de paiement(L)',
            ], [
                'name'  => 'sell_price',
                'data'  => 'sell_price',
                'title' => 'prix de vente',
                'render' => "$.fn.dataTable.render.number(' ', '.', 0)"
            ],
            //  [
            //     'name'  => 'provider',
            //     'data'  => 'provider.name',
            //     'title' => 'fournisseur',
            // ],
               [  
               'name'  => 'payment_supplier',
               'data'  => 'payment_supplier',
               'title' => 'état de paiement(F)',
               ], [
                'name'  => 'buy_price',
                 'data'  => 'buy_price',
                 'title' => 'prix d\'achat',
                'render' => "$.fn.dataTable.render.number(' ', '.', 0, '')"
             ],
             [
                'name'  => 'quantity',
                 'data'  => 'quantity',
                 'title' => 'qty',         
             ],
             [
                'name'  => 'created_at',
                'data'  => 'created_at',
                'title' => 'date de tran',
            ], [
                'name'       => 'delete',
                'data'       => 'delete',
                'title'      => 'delete',
                'exportable' => false,
                'printable'  => false,
                'orderable'  => false,
                'searchable' => false,
            ],

        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Transaction_' . date('YmdHis');
    }
}
