<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\ProvidersDataTable;
use App\Models\Provider;

class ProviderController extends Controller
{
    public function index(ProvidersDataTable $dataTable) {
        return $dataTable->render('admin.providers.index', ['title' => 'Contrôle des fournisseurs']);
    }

    public function create() {
   
        return view('admin.providers.create', ['title' => 'ajoute fournisseur']);
    }

    public function store() {
        $data = $this->validate(request(),
            [   'name'           => 'required',
                'address'        => 'required',
                'domain'         => 'required',
                'phone_number_1' => 'required|numeric|digits_between:9,10',
                'phone_number_2' => 'nullable|numeric|digits_between:9,10'
            ], [], [
                'name'           => 'name',
                'address'        => 'address',
                'domain'         => 'domain',
                'phone_number_1' => 'phone_number_1',
                'phone_number_2' => 'phone_number_2',
            ]);
        Provider::create($data);
        session()->flash('success', 'Enregistrement ajouté');
        return redirect(aurl('providers'));
    }

       public function edit($id) {
        
        $provider = Provider::find($id);
        $title = 'Edit fournisseur';

        return view('admin.providers.edit', compact('provider', 'title'));
    }

        public function update(Request $r, $id) {

         $data = $this->validate(request(),
            [   'name'           => 'required',
                'address'        => 'required',
                'domain'         => 'required',
                'phone_number_1' => 'required|numeric|digits_between:9,10',
                'phone_number_2' => 'nullable|numeric|digits_between:9,10'
            ], [], [
                'name'           => 'name',
                'address'        => 'address',
                'domain'         => 'domain',
                'phone_number_1' => 'phone_number_1',
                'phone_number_2' => 'phone_number_2',
            ]);
     
        Provider::where('id', $id)->update($data);
        session()->flash('success', trans('Enregistrement mis à jour'));
        return redirect(aurl('providers'));
    }

      public function destroy($id) {
        Provider::find($id)->delete();
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('providers'));
    }
}
